from tkinter import *
from tkinter import ttk, font, filedialog as fd
import shutil, os, ctypes, pyglet
from fractions import Fraction
from PIL import ImageTk, Image, ImageOps, ImageDraw, ImageFont
import Program
import Edit_and_add_recipes
import Recipes_frame

class Edit_recipe_instructions_frame(Frame):
    """
    Purpose:
        Displays a text box to be able to edit recipe instructions
    Instance variables:
        self.recipe_name: name of recipe that the instructions are for
        self.top_label: label displaying "{Recipe_name} recipe instructions"
        self.instructions_textbox: text box displaying recipe instructions
        self.done_button: done button that returns you to editing the recipe
    Methods:
        done_button_clicked: closes the frame and saves the instructions
        set_up_screen: changes the text and title to a new recipe and instructions
    """

    def __init__(self, parent):
        Frame.__init__(self, parent)

        self.recipe_name = None
        self.top_label = Label(self)
        self.top_label.pack()
        self.instructions_textbox = Text(self, width=10, height=5)
        self.instructions_textbox.pack(fill="both", expand=True)
        self.done_button = Button(
            self, text="Done", command=lambda: self.done_button_clicked()
        )
        self.done_button.pack(pady=(5, 20))

    def done_button_clicked(self):
        recipe = Program.Program.search_recipe_name(self.recipe_name)
        recipe.instructions = self.instructions_textbox.get("0.0", END)[0:-1]
        Program.Program.save("recipes.csv")
        Program.Program.controller.frames[Edit_and_add_recipes.Edit_and_add_recipes].update_instructions(
            self.recipe_name
        )
        self.recipe_name = None
        self.top_label.config(text="")
        self.instructions_textbox.delete("0.0", END)
        Program.Program.controller.change_frames(Edit_and_add_recipes.Edit_and_add_recipes)
        Program.Program.controller.frames[Recipes_frame.Recipes_frame].refresh_window()

    def set_up_screen(self, recipe_name):
        self.recipe_name = recipe_name
        recipe = Program.Program.search_recipe_name(recipe_name)
        self.top_label.config(text=f"{recipe_name} recipe instructions")
        self.instructions_textbox.insert("0.0", recipe.instructions)

    def change_colors(self, bg_color, primary_color, primary_variant, secondary_color):
        elevation_1_color = Program.Program.convert_rgb_to_hex(
            Program.Program.overlay_colors(
                Program.Program.convert_hex_to_rgb(bg_color), (255, 255, 255), 0.05
            )
        )
        if Program.Program.light_mode:
            button_text_color = "#FFFFFF"
            label_color = Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(elevation_1_color), (0, 0, 0), 0.87
                )
            )
        else:
            button_text_color = "#000000"
            label_color = Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(elevation_1_color), (255, 255, 255), 0.87
                )
            )

        self.config(bg=bg_color)
        self.top_label.config(bg=elevation_1_color, fg=label_color)
        self.instructions_textbox.config(bg=elevation_1_color, fg=label_color)
        self.done_button_image = Program.Program.create_rounded_button_image(
            bg_color,
            primary_color,
            Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(primary_color),
                    Program.Program.convert_hex_to_rgb(button_text_color),
                    0.87,
                )
            ),
            "Done",
            self.done_button.winfo_width(),
            self.done_button.winfo_height(),
            22,
        )
        self.done_button.config(
            border="0",
            relief="flat",
            borderwidth=0,
            highlightthickness=0,
            activebackground=bg_color,
            image=self.done_button_image,
        )